(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     48527,       1275]
NotebookOptionsPosition[     46435,       1233]
NotebookOutlinePosition[     46831,       1249]
CellTagsIndexPosition[     46788,       1246]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"T", " ", "=", " ", 
  TagBox[
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox[
         RowBox[{"-", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"r", "-", "d"}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"d", " ", 
               SuperscriptBox["h", 
                RowBox[{"2", " ", "\[Alpha]"}]]}], "-", 
              RowBox[{
               SuperscriptBox["h", 
                RowBox[{"2", " ", "\[Alpha]"}]], " ", "r"}], "-", 
              RowBox[{"4", " ", "d", " ", 
               SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", 
               RowBox[{"Gamma", "[", 
                RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["h", "\[Alpha]"], " ", 
               SuperscriptBox["r", "2"], " ", 
               RowBox[{"Gamma", "[", 
                RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
              RowBox[{"4", " ", "r", " ", 
               SuperscriptBox[
                RowBox[{"Gamma", "[", 
                 RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"d", " ", 
             SuperscriptBox["h", "\[Alpha]"]}], "-", 
            RowBox[{
             SuperscriptBox["h", "\[Alpha]"], " ", "r"}], "-", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]], 
        FractionBox[
         RowBox[{
          RowBox[{
           SuperscriptBox["h", "\[Alpha]"], "r"}], "-", 
          RowBox[{
           SuperscriptBox["h", "\[Alpha]"], " ", "d"}]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"d", " ", 
             SuperscriptBox["h", "\[Alpha]"]}], "-", 
            RowBox[{
             SuperscriptBox["h", "\[Alpha]"], " ", "r"}], "-", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]},
       {"0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Input",
 CellChangeTimes->{{3.929279434058901*^9, 3.929279435078808*^9}, {
   3.929279527652284*^9, 3.929279564559193*^9}, {3.9292796019911175`*^9, 
   3.929279702862051*^9}, {3.92927973535273*^9, 3.929279785131836*^9}, {
   3.9292798174602947`*^9, 3.9292798285989876`*^9}, {3.9292801044916687`*^9, 
   3.929280123975029*^9}, {3.929280242180813*^9, 3.9292802703911057`*^9}, {
   3.92928039793182*^9, 3.929280448946863*^9}, {3.929280752432993*^9, 
   3.9292807826994*^9}, 3.9292808323281384`*^9, {3.9292811293067627`*^9, 
   3.929281162745531*^9}, {3.929281219475668*^9, 3.929281236861719*^9}, {
   3.929281390517044*^9, 3.9292814004007397`*^9}, {3.9292814491204853`*^9, 
   3.929281460598768*^9}, {3.929281639356303*^9, 3.929281648044918*^9}, {
   3.929281744455214*^9, 3.929281770160712*^9}, {3.92928242645556*^9, 
   3.929282437276991*^9}, {3.929282476068262*^9, 3.929282476422701*^9}, {
   3.929282630512031*^9, 3.929282655202116*^9}, 3.929282797670363*^9, {
   3.929283344252491*^9, 3.9292833637560444`*^9}, 3.929286050843881*^9, {
   3.9292868764340057`*^9, 3.929286880439266*^9}, {3.92928719979565*^9, 
   3.9292872210580997`*^9}, {3.9292874954021626`*^9, 3.929287556754721*^9}, {
   3.949579245330664*^9, 3.949579369230517*^9}, {3.949675943296896*^9, 
   3.949675996278423*^9}, 3.949676299990078*^9, {3.949676626700947*^9, 
   3.949676627021988*^9}, {3.9496768061115837`*^9, 3.949676806765781*^9}, 
   3.949758772610136*^9, {3.949764274492234*^9, 3.949764296307774*^9}, {
   3.9497649354667263`*^9, 3.9497649358930473`*^9}, 3.949765089651407*^9, {
   3.949766108776011*^9, 3.949766109355507*^9}, {3.950344457042332*^9, 
   3.95034446023263*^9}, {3.950344570382099*^9, 3.9503445820413494`*^9}, 
   3.951978432730636*^9, {3.951982082570204*^9, 3.951982096050159*^9}, {
   3.951982126849615*^9, 3.9519822388411922`*^9}, {3.951982588836317*^9, 
   3.951982675924663*^9}, {3.951982710370889*^9, 3.9519827337375793`*^9}, 
   3.9527950615789433`*^9, {3.952860908701212*^9, 3.9528609129667892`*^9}, 
   3.952861239496073*^9, {3.95336236606472*^9, 3.9533623930853786`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"90d5f73b-287f-8f42-b3c0-d88e205093aa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"d", " ", 
            SuperscriptBox["h", 
             RowBox[{"2", " ", "\[Alpha]"}]]}], "-", 
           RowBox[{
            SuperscriptBox["h", 
             RowBox[{"2", " ", "\[Alpha]"}]], " ", "r"}], "-", 
           RowBox[{"4", " ", "d", " ", 
            SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["h", "\[Alpha]"], " ", 
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
           RowBox[{"4", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"Gamma", "[", 
              RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]], 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"d", " ", 
           SuperscriptBox["h", "\[Alpha]"]}], "-", 
          RowBox[{
           SuperscriptBox["h", "\[Alpha]"], " ", "r"}], "-", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}], ",", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "d"}], " ", 
        SuperscriptBox["h", "\[Alpha]"]}], "+", 
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", "r"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", " ", 
          SuperscriptBox["h", "\[Alpha]"]}], "-", 
         RowBox[{
          SuperscriptBox["h", "\[Alpha]"], " ", "r"}], "-", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.951982241775984*^9, 3.9519827363756027`*^9, 3.951983729165489*^9, 
   3.951984143344536*^9, 3.951984690932089*^9, 3.951992167278982*^9, 
   3.9520028690484877`*^9, 3.952074865852785*^9, {3.952795053656988*^9, 
   3.9527950725758247`*^9}, 3.9528531477978973`*^9, 3.952860915052412*^9, 
   3.9528612479199944`*^9, 3.952861278646591*^9, 3.9533623992772026`*^9, 
   3.953365043963455*^9, {3.973916686555002*^9, 3.9739166989539547`*^9}, 
   3.9739167899660625`*^9, 3.9739168863348103`*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"1d2de4f0-14e7-bd46-80c3-f2b3e6033378"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"A", " ", "=", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox["h", "\[Alpha]"], 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["h", "\[Alpha]"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}]},
      {
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["h", "\[Alpha]"], " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}]}], 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}], 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}]}], 
         RowBox[{
          RowBox[{
           SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
          RowBox[{"r", " ", 
           SuperscriptBox[
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}]]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]}]], "Input",
 CellChangeTimes->{{3.929279803720674*^9, 3.929279955576357*^9}, {
   3.929280135583111*^9, 3.929280144840465*^9}, {3.9292802813710556`*^9, 
   3.9292803009570236`*^9}, {3.9292803350265083`*^9, 3.929280338478174*^9}, {
   3.9292804705325203`*^9, 3.92928054178204*^9}, {3.929280804328483*^9, 
   3.92928082820907*^9}, {3.929281084785969*^9, 3.929281101275228*^9}, {
   3.9292811717187576`*^9, 3.929281197282463*^9}, {3.929281245699559*^9, 
   3.929281279847098*^9}, {3.929281370247715*^9, 3.929281384459751*^9}, {
   3.9292814245924873`*^9, 3.929281437702051*^9}, {3.929281653671589*^9, 
   3.9292816695968227`*^9}, {3.9292818099031315`*^9, 3.929281839696518*^9}, {
   3.9292826759526787`*^9, 3.929282706378315*^9}, {3.929282833078703*^9, 
   3.9292828541675014`*^9}, {3.929283312893509*^9, 3.929283333373584*^9}, {
   3.929286410024631*^9, 3.929286424768184*^9}, {3.929286468836881*^9, 
   3.929286479397098*^9}, {3.929287021096472*^9, 3.929287021681078*^9}, {
   3.92928723085157*^9, 3.9292872590192165`*^9}, {3.929287566336149*^9, 
   3.9292875910390453`*^9}, {3.929292300675623*^9, 3.929292301150078*^9}, {
   3.949579383860235*^9, 3.9495794658230705`*^9}, {3.949676022689556*^9, 
   3.949676129554508*^9}, {3.949764308886664*^9, 3.949764332896335*^9}, 
   3.950344488912361*^9, 3.9519822912502365`*^9, 3.9519827493727646`*^9, {
   3.9527950713531513`*^9, 3.9527950980451584`*^9}, 3.953362493170496*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"c77322c7-9d5f-ba45-bc76-f1fda06828ea"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["h", "\[Alpha]"], 
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["h", "\[Alpha]"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}]}], 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]]}], ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox["h", 
         RowBox[{"2", " ", "\[Alpha]"}]], " ", 
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}]}], 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
        RowBox[{"r", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}]]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.9292941323411508`*^9, {3.949579440535551*^9, 3.949579467364916*^9}, 
   3.949676132756342*^9, 3.9496763063989544`*^9, 3.949676632997736*^9, 
   3.949676812415343*^9, 3.9497587775141335`*^9, 3.9497643341777687`*^9, 
   3.949764953605549*^9, 3.950344491471588*^9, 3.950359369761217*^9, 
   3.950360241527464*^9, 3.951982293085415*^9, 3.951982750836609*^9, 
   3.951983732557017*^9, 3.951984143480427*^9, 3.9519846909587173`*^9, 
   3.951992167307951*^9, 3.9519942003555756`*^9, 3.9520029133577776`*^9, 
   3.952074865883892*^9, 3.9527950536740665`*^9, 3.95279509939126*^9, 
   3.9528531479160233`*^9, 3.9528609718226852`*^9, 3.9528613292784996`*^9, 
   3.9533624946872787`*^9, 3.95336504406164*^9, 3.973916734683113*^9, 
   3.9739167961725407`*^9, 3.973916886459215*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"48471e2a-1da7-9e4c-b25e-66654463ac0d"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"LM", "=", " ", 
   RowBox[{
    RowBox[{"Inverse", "[", "T", "]"}], ".", "A", ".", "T"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LM", " ", "=", " ", 
   RowBox[{"MatrixForm", "[", "LM", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Simplify", "[", "LM", "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJwdzztIgmEYBeAfG0Jo0yAJupBLCSGoEDmEImVgJOoQFGFSpKH1hYY2WJh/
2hQqLYGDRYU/WEoZhYR2WUSCostS1BBuoRQY3SDyfMPhgcM7vKfVMmOY4DEM
01gNFIcfs77ekip0l8vDJ7nRslRV69ij1nudVnhaWrNBu0xC4Befpdqn5t3Q
OvRALSuOfJB92/fD6y0mAj01YWrUFkvAV2LehRoHOYSTjCoD4+/6HDxpIGfw
cjor8Ffd/OwXQbYjOQwvlL/U1LecwJGPvlkYL+StLPbEmm3QtSDchrVEtANv
xJICjA/or6BnNX0L+VzqHkrrnjuXsWesQmWE5W4YWmxXUomiB2oEMjVsWf+b
g7q2Ji/U8jIsTMTSAZiOGDlochUTUFoMqgL4K9SlheaDH0MQd8ljExzf0J3D
qHqUWnkZ5FbQc27qPwUF1tQ=
  "],
 CellLabel->"In[3]:=",ExpressionUUID->"68e2cc65-21da-844a-b56f-4339ff3bb2d8"],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       FractionBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"2", " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]], 
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d", "-", "r"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["h", 
               RowBox[{"2", " ", "\[Alpha]"}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["h", "\[Alpha]"], " ", 
              RowBox[{"(", 
               RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
              RowBox[{"Gamma", "[", 
               RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
             RowBox[{"4", " ", "r", " ", 
              SuperscriptBox[
               RowBox[{"Gamma", "[", 
                RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]},
      {
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["h", "\[Alpha]"], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["h", 
                RowBox[{"2", " ", "\[Alpha]"}]], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["h", "\[Alpha]"], " ", 
               RowBox[{"(", 
                RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
               RowBox[{"Gamma", "[", 
                RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
              RowBox[{"4", " ", "r", " ", 
               SuperscriptBox[
                RowBox[{"Gamma", "[", 
                 RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["h", "\[Alpha]"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}], 
       FractionBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"2", " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], 
  RowBox[{"(*", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"a", 
        RowBox[{"-", "b"}]},
       {"b", "a"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "*)"}]}]], "Input",
 CellChangeTimes->{{3.9739171905485973`*^9, 
  3.9739172308428745`*^9}},ExpressionUUID->"bff37d7a-0ab4-0a40-bbae-\
025097c92838"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"doing", " ", "the", " ", "translation", " ", 
    RowBox[{"(", 
     RowBox[{"u", ",", "v"}], ")"}]}], " ", "=", " ", 
   RowBox[{"T", " ", 
    RowBox[{"(", " ", 
     RowBox[{"x", ",", "y"}], ")"}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.950344514225092*^9, 3.9503445538775806`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"e5e6fd61-82dc-6549-8623-c59e22c2c89e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"u", " ", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{"-", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", "-", "d"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"d", " ", 
            SuperscriptBox["h", 
             RowBox[{"2", " ", "\[Alpha]"}]]}], "-", 
           RowBox[{
            SuperscriptBox["h", 
             RowBox[{"2", " ", "\[Alpha]"}]], " ", "r"}], "-", 
           RowBox[{"4", " ", "d", " ", 
            SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["h", "\[Alpha]"], " ", 
            SuperscriptBox["r", "2"], " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
           RowBox[{"4", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"Gamma", "[", 
              RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", " ", 
          SuperscriptBox["h", "\[Alpha]"]}], "-", 
         RowBox[{
          SuperscriptBox["h", "\[Alpha]"], " ", "r"}], "-", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]], ")"}], "*", 
    "x"}], " ", "+", " ", 
   RowBox[{
    RowBox[{"(", 
     FractionBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], "r"}], "-", 
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", "d"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", " ", 
          SuperscriptBox["h", "\[Alpha]"]}], "-", 
         RowBox[{
          SuperscriptBox["h", "\[Alpha]"], " ", "r"}], "-", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]], ")"}], "*", 
    "y"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"v", " ", "=", "y"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.929292478846873*^9, 3.9292925217317257`*^9}, {
   3.92929258511763*^9, 3.929292862831389*^9}, {3.9495840914850655`*^9, 
   3.949584195370713*^9}, {3.949758547111725*^9, 3.949758605516512*^9}, 
   3.949758685477897*^9, 3.9497588010464497`*^9, {3.949764897287579*^9, 
   3.94976489869771*^9}, {3.950344588869417*^9, 3.9503446360562325`*^9}, {
   3.9503450010085773`*^9, 3.950345011431977*^9}, {3.951983419258112*^9, 
   3.951983420734913*^9}, 3.9519834745912633`*^9, {3.951983514493501*^9, 
   3.95198351592461*^9}, {3.951983932940222*^9, 3.9519839731669865`*^9}, 
   3.9520748637595634`*^9, {3.9528556634300327`*^9, 3.952855685287279*^9}, {
   3.9533650050011196`*^9, 3.953365023364956*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"2e233eb9-f1e2-7b45-b394-bd089dc54f1a"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "d"}], " ", 
       SuperscriptBox["h", "\[Alpha]"]}], "+", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "r"}]}], ")"}], " ", "y"}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"d", " ", 
       SuperscriptBox["h", "\[Alpha]"]}], "-", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "r"}], "-", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"x", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", " ", 
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]]}], "-", 
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]], " ", "r"}], "-", 
        RowBox[{"4", " ", "d", " ", 
         SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["h", "\[Alpha]"], " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
        RowBox[{"4", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"d", " ", 
       SuperscriptBox["h", "\[Alpha]"]}], "-", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "r"}], "-", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{
  3.92929417707337*^9, 3.949584200357252*^9, {3.9497585925097237`*^9, 
   3.9497586065820713`*^9}, 3.949758687964725*^9, {3.9497587892621098`*^9, 
   3.9497588032653027`*^9}, 3.94976490206106*^9, 3.949764963530836*^9, 
   3.9503446024956264`*^9, 3.9503446371433334`*^9, {3.950345002371063*^9, 
   3.950345012844742*^9}, 3.95035939328195*^9, 3.950360254500067*^9, 
   3.951983733040865*^9, 3.951984143594822*^9, 3.951984691060562*^9, 
   3.9519921674235973`*^9, 3.9520029957983847`*^9, 3.952074865984173*^9, 
   3.952795053754776*^9, 3.9528531479940414`*^9, 3.9528557034541473`*^9, 
   3.95285592958675*^9, 3.952861381372013*^9, 3.953365044282669*^9, 
   3.973916844781393*^9, 3.9739168866508045`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"202aa952-7109-ca47-9201-afa9f3174986"],

Cell[BoxData["y"], "Output",
 CellChangeTimes->{
  3.92929417707337*^9, 3.949584200357252*^9, {3.9497585925097237`*^9, 
   3.9497586065820713`*^9}, 3.949758687964725*^9, {3.9497587892621098`*^9, 
   3.9497588032653027`*^9}, 3.94976490206106*^9, 3.949764963530836*^9, 
   3.9503446024956264`*^9, 3.9503446371433334`*^9, {3.950345002371063*^9, 
   3.950345012844742*^9}, 3.95035939328195*^9, 3.950360254500067*^9, 
   3.951983733040865*^9, 3.951984143594822*^9, 3.951984691060562*^9, 
   3.9519921674235973`*^9, 3.9520029957983847`*^9, 3.952074865984173*^9, 
   3.952795053754776*^9, 3.9528531479940414`*^9, 3.9528557034541473`*^9, 
   3.95285592958675*^9, 3.952861381372013*^9, 3.953365044282669*^9, 
   3.973916844781393*^9, 3.9739168866538486`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"03d8ee46-f17a-504b-a6b3-a04f1eee6f32"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"B", " ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"h", "^", "\[Alpha]"}], "/", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "*", 
    RowBox[{"(", GridBox[{
       {
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", "u", ")"}], "*", 
           RowBox[{"(", "v", ")"}]}], ")"}]}]},
       {
        RowBox[{"u", "*", "v"}]}
      }], ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9292929973161945`*^9, 3.929293257302248*^9}, 
   3.929294191576653*^9, 3.929294295092339*^9, {3.9495842332336464`*^9, 
   3.949584242074463*^9}, {3.950344640145225*^9, 3.950344644796549*^9}, 
   3.9528557085143585`*^9, 3.953365478000458*^9, {3.973917249631443*^9, 
   3.9739172505615807`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"543807f3-ec68-9147-8e78-e1d03c363bc6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"QM", "=", " ", 
   RowBox[{
    RowBox[{"Inverse", "[", "T", "]"}], ".", "B"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QM", "=", " ", 
   RowBox[{"MatrixForm", "[", "QM", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{" ", 
  RowBox[{"Simplify", "[", "QM", "]"}]}]}], "Input",
 CellChangeTimes->{{3.929293285908048*^9, 3.9292933159416485`*^9}, {
   3.92929339571788*^9, 3.929293411885607*^9}, {3.929293900200737*^9, 
   3.929293901668659*^9}, {3.9292946802290955`*^9, 3.929294681305168*^9}, 
   3.949584247147604*^9, {3.950346306751137*^9, 3.9503463074719257`*^9}, 
   3.9503463431366043`*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"234bf2a6-00cb-a74a-8709-38fa5a7cf81f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", "y", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", "d", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"d", " ", 
            SuperscriptBox["h", "\[Alpha]"], " ", "y"}], "-", 
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"d", "-", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["h", 
                  RowBox[{"2", " ", "\[Alpha]"}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["h", "\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
                 RowBox[{"Gamma", "[", 
                  RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
                RowBox[{"4", " ", "r", " ", 
                 SuperscriptBox[
                  RowBox[{"Gamma", "[", 
                   RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
               ")"}]}]]}]}], ")"}]}], 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d", "-", "r"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["h", 
               RowBox[{"2", " ", "\[Alpha]"}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["h", "\[Alpha]"], " ", 
              RowBox[{"(", 
               RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
              RowBox[{"Gamma", "[", 
               RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
             RowBox[{"4", " ", "r", " ", 
              SuperscriptBox[
               RowBox[{"Gamma", "[", 
                RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
            ")"}]}]]}]]}]},
     {
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", "y", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"d", " ", 
            SuperscriptBox["h", "\[Alpha]"], " ", "y"}], "-", 
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"d", "-", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["h", 
                  RowBox[{"2", " ", "\[Alpha]"}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["h", "\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
                 RowBox[{"Gamma", "[", 
                  RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
                RowBox[{"4", " ", "r", " ", 
                 SuperscriptBox[
                  RowBox[{"Gamma", "[", 
                   RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
               ")"}]}]]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{"d", "-", "r"}], ")"}]}], "-", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9503593997025375`*^9, 3.950360260817644*^9, 3.951983733382513*^9, 
   3.951984143905369*^9, 3.9519844825038166`*^9, 3.9519846911385136`*^9, 
   3.951984734983625*^9, 3.951986351706152*^9, 3.9519921677380047`*^9, 
   3.952003030091202*^9, 3.952074866051712*^9, 3.952795053912483*^9, 
   3.9528531481846104`*^9, 3.952855714686535*^9, 3.952855901580784*^9, 
   3.9528559387359905`*^9, 3.9528566347273903`*^9, 3.9528613866075497`*^9, 
   3.952861494080496*^9, 3.953365044448694*^9, 3.9533654936187096`*^9, {
   3.9739168639051685`*^9, 3.973916886930475*^9}, 3.973917258739807*^9},
 CellLabel->
  "Out[19]//MatrixForm=",ExpressionUUID->"31661cad-d9d6-a74d-af16-\
5570efd0c76c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f1", "=", " ", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", "y", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", " ", "d", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"d", " ", 
            SuperscriptBox["h", "\[Alpha]"], " ", "y"}], "-", 
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", "y"}], "+", 
           RowBox[{"x", " ", 
            SqrtBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{"d", "-", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["h", 
                  RowBox[{"2", " ", "\[Alpha]"}]], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["h", "\[Alpha]"], " ", 
                 RowBox[{"(", 
                  RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
                 RowBox[{"Gamma", "[", 
                  RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
                RowBox[{"4", " ", "r", " ", 
                 SuperscriptBox[
                  RowBox[{"Gamma", "[", 
                   RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
               ")"}]}]]}]}], ")"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"d", "-", "r"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["h", 
               RowBox[{"2", " ", "\[Alpha]"}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["h", "\[Alpha]"], " ", 
              RowBox[{"(", 
               RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
              RowBox[{"Gamma", "[", 
               RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
             RowBox[{"4", " ", "r", " ", 
              SuperscriptBox[
               RowBox[{"Gamma", "[", 
                RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
        ")"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "^", "2"}], ",", "xy"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.973916965981903*^9, 3.9739169771082*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"e8d57faf-0256-f246-bb5c-be08c3847f96"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", "y", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "d", " ", "r"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", "r", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}], 
    RowBox[{"2", " ", "r", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "y", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"d", " ", 
       SuperscriptBox["h", "\[Alpha]"], " ", "y"}], "-", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", "y"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "d", " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}], 
   RowBox[{"2", " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
        RowBox[{"4", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
       ")"}]}]]}]]}]], "Output",
 CellChangeTimes->{3.9739169796652317`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"f20bc598-b361-724e-89be-14e7590c5eea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", "=", " ", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "y", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "y"}], "-", 
         RowBox[{
          SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", "y"}], "+", 
         RowBox[{"x", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["h", 
                RowBox[{"2", " ", "\[Alpha]"}]], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["h", "\[Alpha]"], " ", 
               RowBox[{"(", 
                RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
               RowBox[{"Gamma", "[", 
                RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
              RowBox[{"4", " ", "r", " ", 
               SuperscriptBox[
                RowBox[{"Gamma", "[", 
                 RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
             ")"}]}]]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["h", "\[Alpha]"], " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}]}], "-", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "^", "2"}], ",", "xy"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.973917035805382*^9, 3.973917050578499*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"c9d4b8c4-7686-0940-aa41-13a030f451cd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", "y", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"d", " ", 
        SuperscriptBox["h", "\[Alpha]"], " ", "y"}], "-", 
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", "y"}]}], ")"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}]}], "-", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", "y", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
        RowBox[{"4", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}]}], "-", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{3.9739170528432827`*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"8ea507d3-d918-004c-9ad4-2e45412b692c"]
}, Open  ]]
},
WindowSize->{949, 521},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.1 for Microsoft Windows (64-bit) (July 16, 2024)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"97bf81f3-7245-e04b-b5ca-a9245299c9b6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 4873, 103, 62, "Input",ExpressionUUID->"90d5f73b-287f-8f42-b3c0-d88e205093aa"],
Cell[5456, 127, 2788, 72, 98, "Output",ExpressionUUID->"1d2de4f0-14e7-bd46-80c3-f2b3e6033378"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8281, 204, 3368, 76, 69, "Input",ExpressionUUID->"c77322c7-9d5f-ba45-bc76-f1fda06828ea"],
Cell[11652, 282, 2325, 60, 51, "Output",ExpressionUUID->"48471e2a-1da7-9e4c-b25e-66654463ac0d"]
}, Open  ]],
Cell[13992, 345, 902, 20, 66, "Input",ExpressionUUID->"68e2cc65-21da-844a-b56f-4339ff3bb2d8"],
Cell[14897, 367, 6100, 169, 83, "Input",ExpressionUUID->"bff37d7a-0ab4-0a40-bbae-025097c92838"],
Cell[21000, 538, 431, 10, 28, "Input",ExpressionUUID->"e5e6fd61-82dc-6549-8623-c59e22c2c89e"],
Cell[CellGroupData[{
Cell[21456, 552, 3024, 75, 148, "Input",ExpressionUUID->"2e233eb9-f1e2-7b45-b394-bd089dc54f1a"],
Cell[24483, 629, 2763, 72, 56, "Output",ExpressionUUID->"202aa952-7109-ca47-9201-afa9f3174986"],
Cell[27249, 703, 827, 12, 32, "Output",ExpressionUUID->"03d8ee46-f17a-504b-a6b3-a04f1eee6f32"]
}, Open  ]],
Cell[28091, 718, 863, 23, 41, "Input",ExpressionUUID->"543807f3-ec68-9147-8e78-e1d03c363bc6"],
Cell[CellGroupData[{
Cell[28979, 745, 728, 16, 66, "Input",ExpressionUUID->"234bf2a6-00cb-a74a-8709-38fa5a7cf81f"],
Cell[29710, 763, 6044, 155, 146, "Output",ExpressionUUID->"31661cad-d9d6-a74d-af16-5570efd0c76c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35791, 923, 3492, 92, 168, "Input",ExpressionUUID->"e8d57faf-0256-f246-bb5c-be08c3847f96"],
Cell[39286, 1017, 2901, 87, 106, "Output",ExpressionUUID->"f20bc598-b361-724e-89be-14e7590c5eea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42224, 1109, 2038, 55, 56, "Input",ExpressionUUID->"c9d4b8c4-7686-0940-aa41-13a030f451cd"],
Cell[44265, 1166, 2154, 64, 56, "Output",ExpressionUUID->"8ea507d3-d918-004c-9ad4-2e45412b692c"]
}, Open  ]]
}
]
*)

